<?php

namespace App\Models\OrderItem;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderItem extends Model 
{

    protected $table = 'order_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function order()
    {
        return $this->morphMany('Order', 'order_id');
    }

}